///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// test a+-b, a*b and so...
//
// usage:
//   gzip -d < amub_tst_in.hb.gz | amub_tst | octave -q
//
//  machine-precision independent computation:
//   gzip -d < amub_tst_in.hb.gz | amub_tst -trunc 12 | octave -q
//
#include "rheolef/skit.h"
using namespace rheolef;
using namespace std;

Float eps1 = 1e-7;
template <class T>
inline T my_round (const T& x) { return eps1*T(int(x/eps1+0.5)); }
    
template <class Iterator>
void
round_value (Iterator first, Iterator last)
{
    while (first != last) {
        *first = my_round(*first);
	first++;
    }
}
int main(int argc, char**argv)
{
    bool do_trunc = false;
    int digits10 = numeric_limits<Float>::digits10;
    
    // avoid machine-dependent output digits in non-regression mode:
    if (argc == 3) {
 	do_trunc = true;
        cout.setf(ios::scientific, ios::fixed);
        digits10 = atoi(argv[2]);
	eps1=sqrt(pow(Float(10), Float(-digits10)));
	cout << "eps1=sqrt(10^(-" << digits10 << "));\n";
    }
    cout << setprecision(digits10);

    csr<Float> a, b, c;
    cin >> a >> b >> c;

    Float r = 1;
    csr<Float> ar = a + r*trans(b)*b;
    csr<Float> br = b - r*c*b;
    csr<Float> cr = c - r*c*c;

   if (do_trunc) {
	round_value(ar.a().begin(), ar.a().end());
	round_value(br.a().begin(), br.a().end());
	round_value(cr.a().begin(), cr.a().end());
   }
   cout << ml
         << "r=" << r << ";\n"
         << "a=" << a << ";\n"
         << "b=" << b << ";\n"
         << "c=" << c << ";\n"
         << "ar=" << ar << ";\n"
         << "br=" << br << ";\n"
         << "cr=" << cr << ";\n"
  	 ; 
   if (!do_trunc) {
       cout
         << "erra=norm(ar-(a+r*b'*b))\n"
         << "errb=norm(br-(b-r*c*b))\n"
         << "errc=norm(cr-(c-r*c*c))\n"
         << endl;
    } else {
       cout 
         << "erra=eps1*round(norm(ar-(a+r*b'*b))/eps1)\n"
         << "errb=eps1*round(norm(br-(b-r*c*b))/eps1)\n"
         << "errc=eps1*round(norm(cr-(c-r*c*c))/eps1)\n"
         << endl;
    }
    return 0;
}
